/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * \file    DM388_types.h
 *
 * \brief   Defines the statndard types for CCS sample code
 *
 * This header file contains the standard typedefs and macros
 * for use with CCS test code for DM388 Board.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM388_types_H_
#define _DM388_types_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */

/**
@addtogroup DM388 Types
@{
*/

/*
 *====================
 * Defines
 *====================
 */
#define SUCCESS		0
#define FAILED		-1

#define SW_BREAKPOINT       asm( " .long 0xe1200070" );

#ifndef NULL
#define NULL 0
#endif

/*
 *====================
 * Typedefs
 *====================
 */

typedef unsigned char 	UINT8;
typedef unsigned short 	UINT16;
typedef unsigned int 	UINT32;
typedef char 	INT8;
typedef short 	INT16;
typedef int 	INT32;
typedef INT16 TEST_STATUS;
typedef int STATUS;


INT32 platform_write(const char *fmt, ... );
void DM388_wait(UINT32 u32Delay);
void DM388_usecDelay(UINT32 u32usec);

/* @} */   /* End of DM388 Types */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM388_types_H_ */
